#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../pages/user_menu'
require_relative '../../module/database/MongoUtility'

describe '[Story# VAR-2827: VAR -Confirm navigation away from New Appointment/Request form without submission]
          [Story# VAR-10083: Return to Appointments/Requests]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @modal = Modal.new(@driver)

    TITLE = "Appointments/Requests"
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")
    @@cc_enabled = @common.ccEnabled
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-6435|TC#VAR-6436: Modal shows up to prompt user to save the unsaved changes.
         Modal Title: Confirmation
         Modal Body:You have not completed your appointment/request. If you wish to continue without completing,
         select CONTINUE, otherwise select RETURN to return to the New Appointments/Requests screen.
         Modal buttons: Continue and Return
         AC#VAR-10131|TC#10132: Return to Appointments/Requests' do

    it 'After the user Selects the Clinic and tries to navigate away from the page, Confirmation Modal shows up' do
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic('32')
      @common.waitWhileSpinnerPresent
      @new_appointment.back_btn
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Confirmation")
    end

    it "Verify the details of confirmation modal" do
      expect(@modal.content).to eq("You have not completed your appointment/request. If you wish to continue without completing, select CONTINUE, otherwise select RETURN to return to the New Appointments/Requests screen.")
    end

    it "Verify the text of Continue and Return buttons present on confirmation modal" do
      expect(@modal.buttons_elements[0].text).to eq("Continue")
      expect(@modal.buttons_elements[1].text).to eq("Return")
    end

    it 'Clicking Return closes the modal and returns the user to the detail screen with focus on the header. ' do
      @modal.buttons_elements[1].click
      expect(@new_appointment.primary_header).to eq("New Appointment/Request")
    end

    it 'Clicking Continue closes the modal and advances the user to the navigation item selected.' do
      @new_appointment.back_btn
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click
      expect(@landing_appointments.primary_header).to eq("Appointments/Requests")
    end

    it 'After the user Selects the Clinic and tries to navigate to provide feedback, Confirmation Modal shows up' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic('32')
      @common.waitWhileSpinnerPresent
      @user_menu.clickUserMenu
      @user_menu.clickFeedback
      @common.waitWhileSpinnerPresent
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      if (@@cc_enabled ==true)
        expect(@modal.modalTitle).to eq("Exit Confirmation")
      elsif(@@cc_enabled ==false)
        expect(@modal.modalTitle).to eq("Confirmation")
        end

    end

    it "Verify details of Exit Confirmation Modal" do
      if (@@cc_enabled ==true)
        expect(@modal.content).to eq("You are about to leave New Appointment/Request form. Any changes you have made will be lost. Do you want to continue?")
      elsif(@@cc_enabled ==false)
        expect(@modal.content).to eq("You have not completed your appointment/request. If you wish to continue without completing, select CONTINUE, otherwise select RETURN to return to the New Appointments/Requests screen.")
      end
    end

    it "verify Text of buttons present" do
      if (@@cc_enabled ==true)
        expect(@modal.buttons_elements[0].text).to eq("Yes")
        expect(@modal.buttons_elements[1].text).to eq("No")
      elsif(@@cc_enabled ==false)
        expect(@modal.buttons_elements[0].text).to eq("Continue")
        expect(@modal.buttons_elements[1].text).to eq("Return")
      end
    end

    it 'Clicking Return closes the modal and returns the user to the New Appointment Request Form' do
      @modal.buttons_elements[1].click
      expect(@new_appointment.primary_header).to eq("New Appointment/Request")
    end

    #Ignoring this Test due to Open Feedback Defect VAR-12127
    xit 'Clicking Continue closes the modal and advances the user to the Feedback Page.' do
      @user_menu.clickUserMenu
      @user_menu.clickFeedback
      @common.waitWhileSpinnerPresent
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click
      expect(@landing_appointments.primary_header).to eq("Feedback")
    end

  end

end
